<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Listing extends Widget_Base {

	public function get_name() {
		return 'autohive_listing';
	}

	public function get_title() {
		return esc_html__( 'Autohive Listing', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	public function get_style_depends() {
		return ['swiper'];
	}

	public function get_script_depends() {
		return [ 'swiper', 'isotop' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Listing Tab', 'autohive-core' ),
					'2' => esc_html__( '02: Inventory', 'autohive-core' ),
					'3' => esc_html__( '03: Listing Carusel', 'autohive-core' ),
				],
				'default' => '1',
			]
		);
		$this->add_control(
			'inventory', [
				'label'   => esc_html__( 'Inventory layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'grid' => esc_html__( 'Inventory Grid ', 'autohive-core' ),
					'list' => esc_html__( 'Inventory List', 'autohive-core' ),
				],
				'default' => 'grid',
				'condition' => [
					'layout' => '2',
				]
			]
		);

		$this->end_controls_section(); //End Layout


		//======================== Section Contents ==========================//
		$this->start_controls_section(
			'sec_contents', [
				'label' => __( 'Contents', 'autohive-core' ),
			]
		);

		$this->add_responsive_control(
			'tab_align', [
				'label' => esc_html__('Tab Alignment', 'textdomain'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__('Left', 'textdomain'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'textdomain'),
						'icon' => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => esc_html__('Right', 'textdomain'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'flex-end',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .collection-filter-controls' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); //End Section Contents


		//================================ Query Tab Filter Layout 01 ============================//
		$this->start_controls_section(
			'query_filter2', [
				'label' => __( 'Product Tab', 'autohive-core' ),
				'condition' => [
					'layout' => [ '1' ]
				]
			]
		);

		$filter2 = new \Elementor\Repeater();

		$filter2->add_control(
			'tab_title', [
				'label' => esc_html__( 'Tab Title', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'New Arrivals'
			]
		);

		$filter2->add_control(
			'select_query', [
				'label' => esc_html__( 'Select Query', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'new_arrival' => esc_html__( 'New Arrivals', 'autohive-core' ),
					'featured' => esc_html__( 'Featured', 'autohive-core' ),
					'popular'=> esc_html__( 'Popular', 'autohive-core' ),
				],
				'default' => 'new_arrival'
			]
		);

		$filter2->add_control(
			'title_length', [
				'label' => esc_html__('Title Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 8
			]
		);

		$filter2->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 6
			]
		);

		$filter2->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude', 'autohive-core' ),
				'description' => esc_html__( 'Enter the product ID to hide. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'listing_tab', [
				'label' => esc_html__( 'Add Product Tab', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $filter2->get_controls(),
				'title_field' => '{{{ tab_title }}}',
			]
		);


		$this->end_controls_section(); //End Filter Tab 01


		//======================== Filter Options 02, 03 ==========================//
		$this->start_controls_section(
			'filter', [
				'label' => __( 'Filter', 'autohive-core' ),
				
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show Posts Count', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4
			]
		);

		$this->add_control(
			'cats', [
				'label' => esc_html__( 'Category', 'autohive-core' ),
				'type'      => Controls_Manager::SELECT2,
				'options'   => \Autohive_Core_Helper::get_the_category_array(),
				'label_block' => true,
				'multiple'  => true,
			]
		);

		$this->add_control(
			'title_length', [
				'label' => esc_html__( 'Title Character Limit', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 20
			]
		);

		$this->add_control(
			'excerpt_length', [
				'label' => esc_html__( 'Excerpt Character Limit', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 20
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'orderby', [
				'label' => esc_html__( 'Order By', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => 'None',
					'ID' => 'ID',
					'author' => 'Author',
					'title' => 'Title',
					'name' => 'Name (by post slug)',
					'date' => 'Date',
					'rand' => 'Random',
				],
				'default' => 'none'
			]
		);

		$this->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude Blog', 'autohive-core' ),
				'description' => esc_html__( 'Enter the Listting post IDs to hide/exclude. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->end_controls_section(); //End Filter's

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

		
		//======================== Slider Control ======================//
		$this->start_controls_section(
			'slider_control_settings', [
				'label' => __( 'Slider Control', 'authohive-core' ),
				'tab'	=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout' => [ '3' ],
				]
			]
		);

		$this->add_control(
			'show_items_desktop', [
				'label'     => esc_html__( 'Display Items [Desktop]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 3,
			]
		);

		$this->add_control(
			'show_items_tablet', [
				'label'     => esc_html__( 'Display Items [Tablet]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 2
			]
		);

		$this->add_control(
			'show_items_mobile', [
				'label'     => esc_html__( 'Display Items [Mobile]', 'authohive-core' ),
				'type'      => Controls_Manager::NUMBER,
				'default'	=> 1
			]
		);

		$this->add_control(
			'item_space', [
				'label' => __( 'Item Space', 'authohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 24
			]
		);

		$this->add_control(
			'item_speed', [
				'label' => __( 'Speed', 'authohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 1500
			]
		);

		$this->end_controls_section(); //End Slider Control
		

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {
		$settings     = $this->get_settings_for_display();
		extract( $settings );

		global $post;

		$featured = get_post_meta($post->ID, 'featured', true);

		$args = [
			'post_type' => 'autohive_listing',
			'post_status' => 'publish',
		];

		if ( !empty($show_count) ) {
			$args['posts_per_page'] = $show_count;
		}

		if ( !empty($order) ) {
			$args['order'] = $order;
		}

		if ( !empty($orderby) ) {
			$args['orderby'] = $orderby;
		}

		if ( !empty($exclude ) ) {
			$args['post__not_in'] = $exclude;
		}

		if ( !empty($cats && $cats != '') ) {
			$args['tax_query'] = [
				[
					'taxonomy'  => 'category',
					'field'     => 'slug',
					'terms'     => $cats,
				]
			];
		}
		
		

		$listing_post = new \WP_Query( $args );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/listing/layout-'.$layout.'.php';

	}


}