<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Autohive_Core_Helper;
use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Info_Boxes extends Widget_Base {

	public function get_name() {
		return 'autohive_info_boxes';
	}

	public function get_title() {
		return esc_html__( 'Autohive Info Boxes', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-info-box';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Item Info Boxes ==========================//
		$this->start_controls_section(
			'item_info_boxes_sec', [
				'label' => __( 'Item Info Boxes', 'autohive-core' ),
			]
		);

		$this->add_control(
			'icon',[
				'label' => esc_html__( 'Icon', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				
			]
		);

		$this->add_control(
			'title', [
				'label'   => esc_html__( 'Title', 'autohive-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Ev Charging',
				'label_block' => true,
			]
		);

		$this->add_control(
			'title', [
				'label'   => esc_html__( 'Title', 'autohive-core' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Ev Charging',
			]
		);

		$this->add_control(
			'content', [
				'label'   => esc_html__( 'Content', 'autohive-core' ),
				'type'    => Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'btn_label', [
				'label'   => esc_html__( 'Button Label', 'autohive-core' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Explore More',
			]
		);

		$this->add_control(
			'btn_url', [
				'label'   => esc_html__( 'Button URL', 'autohive-core' ),
				'type'    => Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
			]
		);	

		$this->end_controls_section(); //End Item Info Boxes

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

		//============================= Contents Style ============================== //
		$this->start_controls_section(
			'item_content_style', [
				'label' => __( 'Item Contents', 'autohive-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		// Title Options
		$this->add_control(
			'item_title_options', [
				'label' => esc_html__( 'Title Options', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'item_title_typo',
				'selector' => '{{WRAPPER}} .__title',
			]
		);

		$this->add_control(
			'item_title_color', [
				'label' => esc_html__( 'Text Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'item_title_hover_color', [
				'label' => esc_html__( 'Hover Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title:hover' => 'color: {{VALUE}}',
				],
			]
		);

		// Sub-Title Options
		$this->add_control(
			'item_content_options', [
				'label' => esc_html__( 'Content Options', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(), [
				'name' => 'item_content_typo',
				'selector' => '{{WRAPPER}} .__content',
			]
		);

		$this->add_control(
			'item_content_color', [
				'label' => esc_html__( 'Text Color', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__content' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section(); // End Contents


		//============================= Section Background ============================== //
		$this->start_controls_section(
			'sec_bg_style', [
				'label' => __( 'Section Background', 'autohive-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'sec_margin', [
				'label' => __( 'Margin', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__autohive_sec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'sec_padding', [
				'label' => __( 'Padding', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .__autohive_sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name' => 'sec_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .__autohive_sec',
			]
		);

		$this->end_controls_section(); //End Section Background

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		?>
        <div class="el-about-box __autohive_sec">
            <?php
			if ( $icon != '' ) { ?>
				<span class="icon-wrapper position-relative">
					<?php \Elementor\Icons_Manager::render_icon( $icon); ?>
            	</span>
				<?php
			}
			if ( $title != '' ) { ?>
				<h5 class="el-heading mt-4 mb-3 __title"><?php echo esc_html($title) ?></h5>
				<?php
			}
			if ( $content != '' ) { ?>
				<p class="mb-4 __content"><?php echo esc_html($content) ?></p>
				<?php
			}
			if ( $btn_label != '' ) { ?>
				<a <?php Autohive_Core_Helper::the_button($btn_url) ?> class="el-explore">
					<?php echo esc_html($btn_label) ?>
					<span class="ms-2">
						<svg width="32" height="8" viewBox="0 0 32 8" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M0 4L26.5 4.00001" stroke="#5CAD2F" stroke-width="1.5"/>
							<path d="M32 3.99997L26 7.46407L26 0.535867L32 3.99997Z" fill="#5CAD2F"/>
						</svg>
					</span>
				</a>
				<?php
			}
			?>
        </div>
		<?php

	}


}