<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Core\Kits\Documents\Tabs\Global_Colors,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Group_Control_Text_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Heading extends Widget_Base {

	public function get_name() {
		return 'autohive_heading';
	}

	public function get_title() {
		return esc_html__( 'Autohive Heading', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-heading';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {

		//==================== Start Heading ======================//
		$this->start_controls_section(
			'section_title', [
				'label' => __( 'Title', 'autohive-core' ),
			]
		);

		$this->add_control(
			'title', [
				'label' => __( 'Title', 'autohive-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'autohive-core' ),
				'default' => __( 'Add Your Heading Text Here', 'autohive-core' ),
				'description' => __( 'Highlighted text must be write in { }. Example : Welcome to { Our Website }', 'autohive-core'),
			]
		);

		$this->add_control(
			'link', [
				'label' => __( 'Link', 'autohive-core' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_tag', [
				'label' => __( 'HTML Tag', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => autohive_el_title_tags(),
				'default' => 'h2',
			]
		);

		$this->add_responsive_control(
			'align', [
				'label' => __( 'Alignment', 'autohive-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => autohive_el_text_alignment(),
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); //End Heading

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control () {

		// ========================== Title Style =========================== //
		$this->start_controls_section(
			'style_title', [
				'label' => __( 'Title', 'autohive-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color', [
				'label' => __( 'Text Color', 'autohive-core' ),
				'type' => Controls_Manager::COLOR,
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-heading-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .elementor-heading-title',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(), [
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .elementor-heading-title',
			]
		);

		$this->add_control(
			'blend_mode', [
				'label' => __( 'Blend Mode', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'Normal', 'autohive-core' ),
					'multiply' => 'Multiply',
					'screen' => 'Screen',
					'overlay' => 'Overlay',
					'darken' => 'Darken',
					'lighten' => 'Lighten',
					'color-dodge' => 'Color Dodge',
					'saturation' => 'Saturation',
					'color' => 'Color',
					'difference' => 'Difference',
					'exclusion' => 'Exclusion',
					'hue' => 'Hue',
					'luminosity' => 'Luminosity',
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-heading-title' => 'mix-blend-mode: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_section(); // End Title Style


		//================================ Title Highlighted Colors ============================//
		$this->start_controls_section(
			'section_highlighted_style', [
				'label' => __( 'Highlighted', 'autohive-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'highlighted_title_color', [
				'label' => __( 'Text Color', 'autohive-core' ),
				'type' => Controls_Manager::COLOR,
				'global' => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-heading-title span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name' => 'highlighted_title_typo',
				'selector' => '{{WRAPPER}} .elementor-heading-title span',
			]
		);

		$this->add_control(
			'is_highlight_divider', [
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'is_highlight_color', [
				'label' => esc_html__( 'Show Border Underline', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'your-plugin' ),
				'label_off' => esc_html__( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'highlighted_border_color', [
				'label' => __( 'Border Color', 'autohive-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'highlighted_border_opacity', [
				'label' => __( 'Border Opacity', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 1,
				'step' => 0.1,
				'default' => 1,
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_responsive_control(
			'highlighted_width', [
				'label' => __( 'Width', 'autohive-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
					],
					'%' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'highlighted_height', [
				'label' => __( 'Height', 'autohive-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
					'%' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'highlighted_hr_position', [
				'label' => __( 'Position Horizontal', 'autohive-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'highlighted_vr_position', [
				'label' => __( 'Position Vertical', 'autohive-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'highlighted_border_radius', [
				'label' => esc_html__( 'Border Radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .autohive-highlighted-heading::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section(); //End Title Highlighted Colors

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		$highlighted_title_class = !empty( $settings['is_highlight_color'] == 'yes' ) ? ' autohive-highlighted-heading' : '';

		if ( '' === $settings['title'] ) {
			return;
		}

		$this->add_render_attribute( 'title', 'class', 'elementor-heading-title' .$highlighted_title_class );

		$this->add_inline_editing_attributes( 'title' );

		$title = !empty($settings['title']) ? $settings['title'] : '';

		if ( ! empty( $settings['link']['url'] ) ) {
			$this->add_link_attributes( 'url', $settings['link'] );

			$title = sprintf( '<a %1$s>%2$s</a>', $this->get_render_attribute_string( 'url' ), $title );
		}

		// Render HTML Markup
		$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['title_tag'] ), $this->get_render_attribute_string( 'title' ), $title );
		echo \Autohive_Core_Helper::kses_post(str_replace(['{', '}'], ['<span>', '</span>'], $title_html));

	}


}