<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Faqs extends Widget_Base {

	public function get_name() {
		return 'autohive_faqs';
	}

	public function get_title() {
		return esc_html__( 'Autohive FAQs', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-help-o';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Tab Category', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//================================ Query Filter ============================//
		$this->start_controls_section(
			'query_filter', [
				'label' => __( 'Filter', 'autohive-core' ),
			]
		);

		$this->add_control(
			'cats', [
				'label' => esc_html__( 'Categories', 'autohive-core' ),
				'description' => esc_html__( 'Display portfolios by categories', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'options' => \Autohive_Core_Helper::get_the_category_array('faq_cat'),
				'label_block' => true,
				'multiple' => true,
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show count', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 9
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'autohive-core' ),
				'description' => esc_html__( '‘ASC‘ – ascending order from lowest to highest values (1, 2, 3; a, b, c). ‘DESC‘ – descending order from highest to lowest values (3, 2, 1; c, b, a).', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'orderby', [
				'label' => esc_html__( 'Order By', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => 'None',
					'ID' => 'ID',
					'author' => 'Author',
					'title' => 'Title',
					'name' => 'Name (by post slug)',
					'date' => 'Date',
					'rand' => 'Random',
					'comment_count' => 'Comment Count',
				],
				'default' => 'none'
			]
		);

		$this->add_control(
			'exclude', [
				'label' => esc_html__( 'Exclude FAQs', 'autohive-core' ),
				'description' => esc_html__( 'Enter the faqs post ID to hide. Input the multiple ID with comma separated', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->end_controls_section(); //End Query filter

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {



	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		$cats = get_terms(array(
			'taxonomy' => 'faq_cat',
			'hide_empty' => true
		));

		//=============== Template Parts ================//
		require __DIR__ . '/templates/faq/layout-'.$layout.'.php';

	}


}