<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Dealers extends Widget_Base {

	public function get_name() {
		return 'autohive_dealers';
	}

	public function get_title() {
		return esc_html__( 'Autohive Dealers', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-post-list';
	}

	public function get_style_depends()	{

		if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
			return [];
		}
		else {
			$settings = $this->get_settings_for_display();
			if ( $settings['layout'] == '2' ) {
				return ['slick'];
			}
			elseif ($settings['layout'] == '4') {
				return ['swiper'];
			}
			return [];
		}
	}

	public function get_script_depends() {

		if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
			return [];
		}
		else {
			$settings = $this->get_settings_for_display();
			if ( $settings['layout'] == '2' ) {
				return ['slick'];
			}
			elseif ($settings['layout'] == '4') {
				return ['swiper'];
			}
			return [];
		}
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( 'Dealer Grid', 'autohive-core' ),
					'2' => esc_html__( 'Featured Dealer [Carousel]', 'autohive-core' ),
					'3' => esc_html__( 'Recent Dealer [Sidebar]', 'autohive-core' ),
					'4' => esc_html__( 'Dealer Gird [Carousel]', 'autohive-core' ),
					'details' => esc_html__( 'Dealer Details', 'autohive-core' ),
					'comments'=> esc_html__( 'Dealer Details [Comments]', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//======================== Title Section ==========================//
		$this->start_controls_section(
			'sec_title', [
				'label' => __( 'Title', 'autohive-core' ),
				'condition' => [
					'layout' => '2'
				]
			]
		);

		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'autohive-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Featured Agents'
			]
		);

		$this->end_controls_section(); //End Title Section


		//======================== Filter Options ==========================//
		$this->start_controls_section(
			'sec_filter', [
				'label' => __( 'Filter', 'autohive-core' ),
			]
		);

		$this->add_control(
			'select_dealer', [
				'label' => esc_html__( 'Show Posts Count', 'autohive-core' ),
				'type' => Controls_Manager::SELECT2,
				'options' => \Autohive_Theme_Helper::get_post_list('listing_dealer'),
				'label_block' => true,
				'multiple' => true,
				'default' => '',
				'condition' => [
					'layout' => '3'
				]
			]
		);

		$this->add_control(
			'show_count', [
				'label' => esc_html__( 'Show Posts Count', 'autohive-core' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4
			]
		);

		$this->add_control(
			'order', [
				'label' => esc_html__( 'Order', 'autohive-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => 'ASC',
					'DESC' => 'DESC'
				],
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'title_length', [
				'label' => esc_html__('Title Length', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::NUMBER,
			]
		);

		$this->end_controls_section(); //End Filter's


		//======================== View Details Button ==========================//
		$this->start_controls_section(
			'sec_btns', [
				'label' => __( 'Button', 'autohive-core' ),
			]
		);

		$this->add_control(
			'view_details', [
				'label' => esc_html__('Button Label', 'autohive-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'View Details',
				'separator' => 'after'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),[
				'name' => 'btn_typo',
				'selector' => '{{WRAPPER}} .__btn',
			]
		);

		$this->add_control(
			'btn_typo',[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section(); // View Details Button


	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {


		//======================= Style Contents ===================//
		$this->start_controls_section(
			'style_contents',[
				'label' => esc_html__( 'Contents', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		//======== Title Options
		$this->add_control(
			'title_options',[
				'label' => esc_html__( 'Title Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),[
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .__title',
			]
		);

		$this->add_control(
			'title_color',[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_hover_color',[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__title:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section(); //Style Contents



		//======================= Style Meta Contents ===================//
		$this->start_controls_section(
			'style_meta_contents',[
				'label' => esc_html__( 'Meta Contents', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		//======== Location Options
		$this->add_control(
			'location_options',[
				'label' => esc_html__( 'Locations Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),[
				'name' => 'location_typo',
				'selector' => '{{WRAPPER}} .__location',
			]
		);

		$this->add_control(
			'location_color',[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__location' => 'color: {{VALUE}}',
				],
			]
		);
	

		//======== Contact Number Options
		$this->add_control(
			'contact_num_options',[
				'label' => esc_html__( 'Contact Number Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),[
				'name' => 'contact_num_typo',
				'selector' => '{{WRAPPER}} .__contact_num',
			]
		);

		$this->add_control(
			'contact_num_color',[
				'label' => esc_html__( 'Text Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__contact_num' => 'color: {{VALUE}}',
				],
			]
		);


		//======== Social Icons Options
		$this->add_control(
			'social_icons_options',[
				'label' => esc_html__( 'Social Icons Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'social_icons_color',[
				'label' => esc_html__( 'Icon Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__icons' => 'color: {{VALUE}}; border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'social_icons_hover_color',[
				'label' => esc_html__( 'Icon Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .__icons:hover' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section(); //Style Meta contents








		//======================= Style Pagination ===================//
		$this->start_controls_section(
			'style_pagination',[
				'label' => esc_html__( 'Pagination', 'textdomain' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'pagination_alignment',[
				'label' => esc_html__( 'Alignment', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', 'textdomain' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'textdomain' ),
						'icon' => 'eicon-text-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'textdomain' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .template-pagination > .page-numbers' => 'justify-content: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section(); //Style Pagination

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		global $post;
		$meta = get_post_meta($post->ID, 'listing_dealer_meta', true);
		$featured_agent = !empty ($meta['featured']) ? $meta['featured'] : '';
		$order_by   = !empty($_GET['order_by']) ? sanitize_text_field($_GET['order_by']) : '';
		$paged      = (get_query_var('paged')) ? get_query_var('paged') : 1;

		$args = [
			'post_type' => 'listing_dealer',
			'post_status' => 'publish',
			'paged'         => $paged,
			'orderby'   => 'meta_value'
		];

		if ( !empty($show_count) ) {
			$args['posts_per_page'] = $show_count;
		}

		if ( !empty($order) ) {
			$args['order'] = $order;
		}

		if ( $order_by != '' && $order_by != 'new' ) {
			if ($order_by == 'popular') {
				$orderby_arr  = ['key' => 'autohive_post_views_count'];
			} elseif ($order_by == 'rated') {
				$orderby_arr  = ['key' => 'comment_count'];
			}
	
			$args['meta_query'] = [
				$orderby_arr,
			];
		}

		if ( $layout == '2' ) {
			$args['meta_query'] = [
				[
					'key' => 'featured',
					'value' => '1',
				]
			];
		}	

		$dealer_lists = new \WP_Query( $args );

		//=============== Template Parts ================//
		include "templates/dealers/dealer-{$layout}.php";

	}


}