<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Counter extends Widget_Base {

	public function get_name() {
		return 'autohive_counter';
	}

	public function get_title() {
		return esc_html__( 'Autohive Counter', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}


	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {

		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Counter', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//=============================== Start Counter ========================//
		$this->start_controls_section(
			'sec_counter', [
				'label' => esc_html__( 'Counter', 'autohive-core' ),
			]
		);

		$counter = new \Elementor\Repeater();
		$counter->add_control(
			'count_num', [
				'label' => esc_html__( 'Number', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 100,
			]
		);

		$counter->add_control(
			'count_num_suffix', [
				'label' => esc_html__( 'Number Suffix', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'k+',
			]
		);

		$counter->add_control(
			'count_text', [
				'label' => esc_html__( 'Text', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Happy Customer'
			]
		);

		$counter->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-google-play',
					'library' => 'fa-brands',
				],
			]
		);

		$this->add_control(
			'counters', [
				'label' => esc_html__( 'Add Counter', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $counter->get_controls(),
				'title_field' => '{{{ count_text }}}',
			]
		);

		$this->add_responsive_control(
			'alignment', [
				'label' => esc_html__( 'Alignment', 'autohive-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'autohive-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'autohive-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'autohive-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .__alignment' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); //End Counter

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/counter/layout-'.$layout.'.php';

	}


}