<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Countdown extends Widget_Base {

	public function get_name() {
		return 'autohive_countdown';
	}

	public function get_title() {
		return esc_html__( 'Autohive Countdown', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-countdown';
	}

	public function get_script_depends() {
		return [ 'moment', 'date-picker', 'countdown' ];
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: ', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//============ Countdown Section ==================//
		$this->start_controls_section(
			'countdown_sec', [
				'label' => __( 'Content', 'quiety-core' ),
			]
		);

		$this->add_control(
			'due_date', [
				'label' => esc_html__( 'Due Date', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DATE_TIME,
				'picker_options' => array( 'm/d/Y H:i:s' )
			]
		);

		$this->end_controls_section(); // End Countdown Section

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );
		$due_date = date_create($settings['due_date']);

		//=============== Template Parts ================//
		require __DIR__ . '/templates/countdown/layout-'.$layout.'.php';

	}


}