<?php
namespace Autohive\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\{Controls_Manager,
	Group_Control_Background,
	Group_Control_Box_Shadow,
	Widget_Base,
	Group_Control_Typography,
	Repeater,
	Utils};

class Autohive_Call_to_Action extends Widget_Base {

	public function get_name() {
		return 'autohive_call_to_action';
	}

	public function get_title() {
		return esc_html__( 'Autohive Call to Action', 'autohive-core' );
	}

	public function get_icon() {
		return 'eicon-call-to-action';
	}

	public function get_categories() {
		return [ 'autohive-elements' ];
	}

	/**
	 * Name: register_controls
	 * Desc: Register controls for these widgets
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function register_controls() {
		$this-> autohive_elementor_content_control();
		$this-> autohive_elementor_style_control();
	}


	/**
	 * Name: autohive_elementor_content_control
	 * Desc: Register content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_content_control() {


		//==================== Select Layout ==========================//
		$this->start_controls_section(
			'select_layout', [
				'label' => __( 'Layout', 'autohive-core' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => esc_html__( 'Layout', 'autohive-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'1' => esc_html__( '01: Double Button', 'autohive-core' ),
				],
				'default' => '1',
			]
		);

		$this->end_controls_section(); //End Layout


		//==================== Section Contents ==========================//
		$this->start_controls_section(
			'sec_contents', [
				'label' => __( 'Contents', 'autohive-core' ),
			]
		);

		$this->add_control(
			'title', [
				'label'   => esc_html__( 'Title', 'autohive-core' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Autohive User Friendly App Available',
			]
		);

		$this->add_control(
			'subtitle', [
				'label'   => esc_html__( 'Subtitle', 'autohive-core' ),
				'type'    => Controls_Manager::TEXTAREA,
			]
		);

		$this->end_controls_section(); //End Section Contents


		//==================== Featured Image ==========================//
		$this->start_controls_section(
			'sec_featured_image', [
				'label' => __( 'Featured Image', 'autohive-core' ),
			]
		);

		$this->add_control(
			'fimage', [
				'label'   => esc_html__( 'Image', 'autohive-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section(); //End Featured Image


		//=============================== Buttons ========================//
		$this->start_controls_section(
			'sec_buttons', [
				'label' => esc_html__( 'Buttons', 'autohive-core' ),
			]
		);

		$buttons = new \Elementor\Repeater();
		$buttons->add_control(
			'btn_label_top', [
				'label' => esc_html__( 'Button Label Top', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Get it on',
				'label_block' => true,
				'separator' => 'after'
			]
		);

		$buttons->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Get Started',
				'label_block' => true,
			]
		);

		$buttons->add_control(
			'btn_url', [
				'label' => esc_html__( 'Button URL', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
			]
		);

		$buttons->add_control(
			'icon', [
				'label' => esc_html__( 'Icon', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-google-play',
					'library' => 'fa-brands',
				],
			]
		);

		$this->add_control(
			'buttons', [
				'label' => esc_html__( 'Add Button', 'autohive-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $buttons->get_controls(),
				'title_field' => '{{{ btn_label }}}',
			]
		);

		$this->end_controls_section(); //End Buttons

	}


	/**
	 * Name: autohive_elementor_style_control
	 * Desc: Register style content
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	public function autohive_elementor_style_control() {


		//==================== Shape Images ==========================//
		$this->start_controls_section(
			'sec_shape_image', [
				'label' => __( 'Shape Images', 'autohive-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'shape', [
				'label'   => esc_html__( 'Shape', 'autohive-core' ),
				'type'    => Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section(); //End Shape Images


		//============================= Section Background ============================== //
		$this->start_controls_section(
			'sec_bg_style', [
				'label' => __( 'Section Background', 'autohive-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'sec_margin', [
				'label' => __( 'Margin', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .autohive_sec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'sec_padding', [
				'label' => __( 'Padding', 'autohive-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .autohive_sec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(), [
				'name' => 'sec_background',
				'label' => __( 'Background', 'autohive-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .autohive_sec',
			]
		);

		$this->end_controls_section(); //End Section Background

	}


	/**
	 * Name: render
	 * Desc: Widgets Render
	 * Params: no params
	 * Return: @void
	 * Since: @1.0.0
	 * Package: @autohive
	 * Author: Themetags
	 */
	protected function render() {

		$settings     = $this->get_settings_for_display();
		extract( $settings );

		//=============== Template Parts ================//
		require __DIR__ . '/templates/call-to-action/layout-'.$layout.'.php';

	}


}