<?php

namespace Autohive\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\{
    Controls_Manager,
    Group_Control_Background,
    Group_Control_Box_Shadow,
    Widget_Base,
    Group_Control_Typography,
    Repeater,
    Utils
};

class Autohive_Advance_Search extends Widget_Base {

    public function get_name() {
        return 'autohive_advance_search';
    }

    public function get_title() {
        return esc_html__('Autohive Advance Search', 'autohive-core');
    }

    public function get_icon() {
        return 'eicon-search';
    }

    public function get_categories() {
        return ['autohive-elements'];
    }

    public function get_style_depends(){
        if (\Elementor\Plugin::$instance->preview->is_preview_mode()) {
            return [];
        } else {
            $settings = $this->get_settings_for_display();
            if ($settings['layout'] == '2') {
                return ['custom-scrollbar'];
            }
            return [];
        }
    }

    public function get_script_depends()
    {
        if( \Elementor\Plugin::$instance->preview->is_preview_mode() ){
            return [];
        }
        else{
            $settings = $this->get_settings_for_display();
            if ($settings['layout'] == '1') {
                return ['autohive-advance-search'];
            }
            elseif ($settings['layout'] == '2') {
                return ['custom-scrollbar'];
            }
            elseif ($settings['layout'] == '3') {
                return ['autoparts-advance-search'];
            }
            return [];
        }
        
    }

    /**
     * Name: register_controls
     * Desc: Register controls for these widgets
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @autohive
     * Author: Themetags
     */
    protected function register_controls()
    {
        $this->autohive_elementor_content_control();
        $this->autohive_elementor_style_control();
    }


    /**
     * Name: autohive_elementor_content_control
     * Desc: Register content
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @autohive
     * Author: Themetags
     */
    public function autohive_elementor_content_control() {


        //==================== Select Layout ==========================//
        $this->start_controls_section(
            'select_layout',
            [
                'label' => __('Layout', 'autohive-core'),
            ]
        );

        $this->add_control(
            'layout', [
                'label'   => esc_html__('Layout', 'autohive-core'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Advance Search', 'autohive-core'),
                    '2' => esc_html__('Inventory Sidebar', 'autohive-core'),
                    '3' => esc_html__('Auto Parts', 'autohive-core'),
                    '4' => esc_html__('Rent a Car', 'autohive-core'),
                    '5' => esc_html__('Advance Search Tab', 'autohive-core'),
                ],
                'default' => '1',
                'frontent_available' => true
            ]
        );

        $this->end_controls_section(); //End Layout


        //==================== Add Search Tab ==========================//
        $this->start_controls_section(
            'select_tab', [
                'label' => __('Add Tab', 'autohive-core'),
	            'condition' => [
					'layout' => [ '1', '5' ]
	            ]
            ]
        );

        $this->add_control(
            'add_tab', [
                'label'   => esc_html__('Add Tab', 'autohive-core' ),
                'type'    => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => [
                    'all' => esc_html__('All Status', 'autohive-core' ),
                    'new' => esc_html__('New', 'autohive-core' ),
                    'used'=> esc_html__('Used', 'autohive-core' ),
                ],
                'default' => 'all',
            ]
        );

        $this->add_control(
            'action_url', [
                'label'   => esc_html__('Inventory Page URL', 'autohive-core' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '#',
            ]
        );

        $this->end_controls_section(); //End Add Search Tab


	    //========================== Form Settings =========================//
        $this->start_controls_section(
            'rent_car_options', [
                'label' => __('Form Settings', 'autohive-core'),
                'condition' => [
                    'layout' => '4'
                ]
            ]
        );

        $this->add_control(
            'rent_inventory_url', [
                'label'   => esc_html__('Action URL', 'autohive-core'),
                'type'    => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '#'
                ]
            ]
        );

        $this->add_control(
            'pickup_label', [
                'label'   => esc_html__('Pickup Label', 'autohive-core'),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Pick Up', 'autohive' )
            ]
        );

        $this->add_control(
            'return_label', [
                'label'   => esc_html__('Return Label', 'autohive-core'),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Return', 'autohive' )
            ]
        );
        $this->add_control(
            'button_label', [
                'label'   => esc_html__('Button Label', 'autohive-core'),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Find a Vehicle', 'autohive' )
            ]
        );


        $this->end_controls_section(); //End Form Settings

    }


    /**
     * Name: autohive_elementor_style_control
     * Desc: Register style content
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @autohive
     * Author: Themetags
     */
    public function autohive_elementor_style_control() {


         //==================== Select Layout ==========================//
         $this->start_controls_section(
            'sec_shape_images',[
                'label' => __('Shape Images', 'autohive-core'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => [ '4' ]
                ]
            ]
        );

        $this->add_control(
            'shape1',[
                'label'   => esc_html__('Shape 01', 'autohive-core'),
                'type'    => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'shape2',[
                'label'   => esc_html__('Shape 02', 'autohive-core'),
                'type'    => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();

    }


    /**
     * Name: render
     * Desc: Widgets Render
     * Params: no params
     * Return: @void
     * Since: @1.0.0
     * Package: @autohive
     * Author: Themetags
     */
    protected function render()
    {

        $settings     = $this->get_settings_for_display();
        extract($settings);

        $listing = '';

        $atts = shortcode_atts(
                [
                    'layout'   => '1',
                    'category' => '',
                    'brand' => 'honda',
                    'posts_per_page' => '2',
                ],
                $settings
            );
        $listing = $atts;

        //=============== Template Parts ================//
        require __DIR__ . '/templates/advance-search/search-form-'.$layout.'.php';

    }
}
