<?php

use Elementor\{Plugin,
	Controls_Manager,
	Group_Control_Typography,
	Repeater,
	Utils
};


define( 'TT_ELEMENTOR_ADDONS_URL', plugins_url( '/', __FILE__ ) );
define( 'TT_ELEMENTOR_ADDONS_PATH', plugin_dir_path( __FILE__ ) );
define( 'TT_ELEMENTOR_ADDONS_FILE', __FILE__ );

define('AUTOHIVE_PLUGIN_EL_ASSETS_URL', plugins_url() . '/autohive-core/elementor/assets');
define('AUTOHIVE_CORE_DIR_EL_IMG', AUTOHIVE_PLUGIN_EL_ASSETS_URL .'/images');


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Autohive_Shortcode {
	/**
	 * Holds the class object.
	 *
	 * @since 1.0
	 *
	 */
	public static $_instance;

	/**
	 * Localize data array
	 *
	 * @var array
	 */
	public $localize_data = array();

	/**
	 * Load Construct
	 *
	 * @since 1.0
	 */

	public function __construct() {
		$this->dir_path = plugin_dir_path( __FILE__ );
		add_action( 'plugins_loaded', [ $this, 'elementor_setup' ] );
		add_action( 'elementor/init', [ $this, 'autohive_elementor_init' ] );

		//
		add_filter( 'elementor/icons_manager/additional_tabs', [ $this, 'autohive_flaticons']);
		// self :: generate_custom_font_icons();
	}


	public function autohive_flaticons( $custom_fonts ) {

		$css_data = get_template_directory_uri() . '/assets/vendors/flaticon/style.css';
		$json_data = plugins_url( 'assets/fonts/flaticon/icon-data.json', __FILE__ );

		$custom_fonts['autohive_flat_icons'] = [
			'name'          => 'flat_icons',
			'label'         => esc_html__( 'FlatIcons', 'autohive-core' ),
			'url'           => $css_data,
			'prefix'        => 'flaticon-',
			'displayPrefix' => 'flaticon',
			'labelIcon'     => 'eicon-filter',
			'ver'           => '',
			'fetchJson'     => $json_data,
			'native'        => true,
		];

		return $custom_fonts;
	}


	public static function generate_custom_font_icons() {

		$css_source = '';
		global $wp_filesystem;
		require_once ( ABSPATH . '/wp-admin/includes/file.php' );
		WP_Filesystem();

		$css_file =  get_template_directory() . '/assets/vendors/flaticon/style.css';
		if ( $wp_filesystem->exists( $css_file ) ) {
			$css_source = $wp_filesystem->get_contents( $css_file );
		}

		preg_match_all( "/\.(flaticon-.*?):\w*?\s*?{/", $css_source, $matches, PREG_SET_ORDER, 0 );
		$iconList = [];
		foreach ( $matches as $match ) {
			$icon = str_replace('flaticon-', '', $match[1]);
			$icons = explode(' ', $icon);
			$iconList[] = current($icons);
		}

		$icons = new \stdClass();
		$icons->icons = $iconList;
		$icon_data = json_encode($icons);
		$file = AUTOHIVE_PLUGIN_URL . '/elementor/assets/fonts/flaticon/icon-data.json';

		global $wp_filesystem;
		require_once ( ABSPATH . '/wp-admin/includes/file.php' );
		WP_Filesystem();
		if ( $wp_filesystem->exists( $file ) ) {
			$content =  $wp_filesystem->put_contents( $file, $icon_data) ;
		}
	}

	/**
	 * Elementor Initialization
	 *
	 * @since 1.0
	 *
	 */
	public function autohive_elementor_init() {
		\Elementor\Plugin::$instance->elements_manager->add_category(
		'autohive-elements', [
				'title' => esc_html__( 'Autohive Elements', 'autohive-core' ),
				'icon'  => 'fa fa-plug',
			]
		);
	}

	/**
	 * Installs default variables and checks if Elementor is installed
	 *
	 * @return void
	 */
	public function elementor_setup() {
		/**
		 * Check if Elementor installed and activated
		 * @see https://developers.elementor.com/creating-an-extension-for-elementor/
		 */
		if ( ! did_action( 'elementor/loaded' ) ) {
			return;
		}

		$this->init_addons();
	}

	/**
	 * Load required file for addons integration
	 */
	public function init_addons() {
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'widgets_area' ] );
		add_action( 'elementor/controls/controls_registered', [ $this, 'controls_area' ] );

	}


	/**
	 * Register widgets by file name
	 */
	public function register_widgets_addon( $file_name ) {
		$widget_manager = Plugin::instance()->widgets_manager;

		$base  = basename( str_replace( '.php', '', $file_name ) );
		$class = ucwords( str_replace( '-', ' ', $base ) );
		$class = str_replace( ' ', '_', $class );
		$class = sprintf( 'Autohive\Widgets\%s', $class ); // Ultraland\Widgets\abc;


		// Class File
		require_once $file_name;

		if ( class_exists( $class ) ) {
			$widget_manager->register( new $class );
		}
	}

	/**
	 * Load widgets require function
	 */
	public function widgets_area() {
		$this->widgets_register();
	}

	/**
	 * Requires widgets files
	 */
	private function widgets_register() {
		foreach ( glob( $this->dir_path . 'widgets/' . '*.php' ) as $file ) {
			$this->register_widgets_addon( $file );
		}
	}

	/**
	 * Load controls require function
	 */
	public function controls_area() {
		$this->controls_register();
	}

	/**
	 * Requires controls files
	 */
	private function controls_register() {
		foreach ( glob( $this->dir_path . 'controls/' . '*.php' ) as $file ) {
			$this->register_controls_addon( $file );
		}
	}

	/**
	 * Register addon by file name.
	 */
	public function register_controls_addon( $file_name ) {
		$controls_manager = Plugin::$instance->controls_manager;

		$base  = basename( str_replace( '.php', '', $file_name ) );
		$class = ucwords( str_replace( '-', ' ', $base ) );
		$class = str_replace( ' ', '_', $class );
		$class = sprintf( 'Autohive\Controls\%s', $class );

		// Class Constructor File
		require_once $file_name;

		if ( class_exists( $class ) ) {
			$name_class = new $class();
			$controls_manager->register( new $class );
		}
	}


	public static function autohive_get_instance() {
		if ( ! isset( self::$_instance ) ) {
			self::$_instance = new Autohive_Shortcode();
		}

		return self::$_instance;
	}
}

$autohive_shortcode = Autohive_Shortcode::autohive_get_instance();