; (function ($) {
    // USE STRICT
    "use strict";
    $(document).ready(function () {

        //MailChimp Newsletter 
        $('[data-autohive-form]').each(function () {
            var $this = $(this);
            $('.form-result', $this).css('display', 'none');
            $this.submit(function () {
                $('button[type="submit"]', $this).addClass('clicked'); // Create a object and assign all fields name and value.

                var values = {};
                $('[name]', $this).each(function () {
                    var $this = $(this),
                        $name = $this.attr('name'),
                        $value = $this.val();
                    values[$name] = $value;
                }); // Make Request

                $.ajax({
                    url: $this.attr('action'),
                    type: 'POST',
                    data: values,
                    success: function success(data) {
                        if (data.error == true) {
                            $('.form-result', $this).addClass('alert-warning').removeClass('alert-success alert-danger').css('display', 'block');
                        } else {
                            $('.form-result', $this).addClass('alert-success').removeClass('alert-warning alert-danger').css('display', 'block');
                        }

                        $('.form-result > .content', $this).html(data.message);
                        $('button[type="submit"]', $this).removeClass('clicked');
                    },
                    error: function error() {
                        $('.form-result', $this).addClass('alert-danger').removeClass('alert-warning alert-success').css('display', 'block');
                        $('.form-result > .content', $this).html('Sorry, an error occurred.');
                        $('button[type="submit"]', $this).removeClass('clicked');
                    }
                });
                return false;
            });
        });
        
        // Inventory & Dealer Listing orderby
        $('.autohive_listing_filter').on('change', 'select.order_by', function () {
            $(this).closest('form').trigger('submit');
        });



        // Page Printing
        $('.page_print').on('click', function () {
            window.print();
        })

        // Copy link script
        var copyText = document.querySelector(".link_copy");
        if (copyText != null) {
            var popupParant = document.querySelector(".right-btns");
            copyText.addEventListener("click", function () {
                this.setAttribute('href', 'javascript:void(0)');
                navigator.clipboard.writeText(this.getAttribute('data-url'));
            
                let popupWarpper = document.createElement('div');
                popupWarpper.setAttribute('class', 'popup_warpper position-absolute');
                let popupText = document.createElement('span');
                popupText.innerHTML = 'Link Coppied';
                popupWarpper.appendChild(popupText);
                popupParant.appendChild(popupWarpper);

                setTimeout(function () {
                    popupWarpper.remove();
                }, 2000);
            })
        }

        
        var addToCartBtn   = document.querySelectorAll(".at_product_action a.button");
        addToCartBtn.forEach(function (element) {
            //element.innerHTML = '';
            element.textContent = '';
        });


        $(document).on("mouseup", function (e) {
            var offCanvusMenu = $(".mobile-menu");

            if (!offCanvusMenu.is(e.target) && offCanvusMenu.has(e.target).length === 0) {
                $(".mobile-menu").removeClass("active");
            }
        }); //section scrolldown

        if ($('.right-btns a').length > 0 ) { 
            $('.right-btns a').tooltip();
        }


        // Update Mini Cart
        $('.add_to_cart_button').click(function () {            
            setTimeout(() => {
                $.post({
                    url: woocommerce_params.ajax_url, // The AJAX URL
                    data: { 'action': 'autohive_update_mini_cart' }, // Send our PHP function
                    success: function (response) {
                        $('.apt_cart_box').html(response); // Repopulate the specific element with the new content
                        console.log(response)
                    }
                });
            }, 1000)
        })

    });
        
})(jQuery);
