(function ($) {
    // USE STRICT
    "use strict";

    let $body       = document.querySelector('body');
    let selectBrand = document.querySelector('#autoparts_car_brand');
    let buildYear   = document.querySelector('#autoparts_car_build_year');
    let carModel    = document.querySelector('#autoparts_car_model');
    let carParts    = document.querySelector('#autoparts_parts_number');
    let carPartsR   = document.querySelector('#datafetch');

    if ( selectBrand != null ) {
        selectBrand.onchange = function (e) {
            buildYear.innerHTML = '';
            carModel.innerHTML = '';
            buildYear.setAttribute('data-brand', this.value);

            listing_advance_search_buildyear();
        };
        function listing_advance_search_buildyear() {

            var $brand = buildYear.getAttribute('data-brand');
            var $setting = 'brand=' + $brand;

            return $.ajax({
                type: "post",
                url: autoparts_advance_search.ajax_url + '?action=autoparts_filter',
                data: $setting,
                dataType: "JSON",
                beforeSend: function () {
                    var s_option = document.createElement('option');
                    s_option.setAttribute('value', '');
                    s_option.innerHTML = 'Select Year';
                    buildYear.appendChild(s_option);
                },
                success: function (res) {

                    if (res.success) {

                        var $posts = (res.data.posts) ? res.data.posts : [];

                        if ($posts.length > 0) {
                            for (let $i = 0; $i < $posts.length; $i++) {
                                let $self = $posts[$i];
                                if (!$self) {
                                    continue;
                                }


                                var year = $self.build_year;
                                year.forEach(element => {
                                    let option = document.createElement('option');
                                    option.setAttribute('class', 'year_list');
                                    option.setAttribute('value', element);
                                    option.innerHTML = element;

                                    buildYear.appendChild(option);
                                });

                            }

                        }

                    }

                },
                error: function (xhr) {
                    console.log('xhr error: ' + xhr.responseText);
                }

            });
        };
    }
    
    if ( buildYear != null ) {
        buildYear.onchange = function (e) {
            carModel.innerHTML = '';
            carModel.setAttribute('data-year', this.value);

            listing_advance_search_model();
        }

        function listing_advance_search_model() {
            
            var $brand = carModel.getAttribute('data-year');
            var $setting = 'buildyear=' + $brand;

            return $.ajax({
                type: "post",
                url: autoparts_advance_search.ajax_url + '?action=autoparts_filter',
                data: $setting,
                dataType: "JSON",
                beforeSend: function () {
                    var s_option = document.createElement('option');
                    s_option.innerHTML = 'Select Model';
                    s_option.setAttribute('value', '');
                    carModel.appendChild(s_option);
                },
                success: function (res) {
                    
                    if (res.success) {

                        var $posts = (res.data.posts) ? res.data.posts : [];

                        if ($posts.length > 0) {
                            for (let $i = 0; $i < $posts.length; $i++) {
                                let $self = $posts[$i];
                                if (!$self) {
                                    continue;
                                }

                                var model = $self.car_model;
                                model.forEach(element => {
                                    let option = document.createElement('option');
                                    option.setAttribute('class', 'car_model_list');
                                    option.setAttribute('value', element);
                                    option.innerHTML = element;
                                    carModel.appendChild(option);
                                });
                                
                            }

                        }

                    }

                },
                error: function (xhr) {
                    console.log('xhr error: ' + xhr.responseText);
                }


            });
        };
    }
    
    if (carModel != null) {
        carModel.onchange = function (e) {
            carParts.setAttribute('data-model', this.value);
            listing_advance_search_parts();
        };

        function listing_advance_search_parts() {
            
            var $carmodel_ = carParts.getAttribute('data-model');
            var $setting = 'carmodel=' + $carmodel_;

            return $.ajax({
                url: autoparts_advance_search.ajax_url + '?action=autoparts_filter',
                type: 'post',
                data:  $setting,
                beforeSend: function () {
                    
                    carPartsR.innerHTML = '';
                    //var span = document.createElement('span');
                    // span.innerHTML = 'Loading...';
                    // inputID.appendChild(span);
                },
                success: function (res) {
                    if (res.success) {

                        var $posts = (res.data.posts) ? res.data.posts : [];

                        if ($posts.length > 0) {
                            for (let $i = 0; $i < $posts.length; $i++) {
                                let $self = $posts[$i];
                                if (!$self) {
                                    continue;
                                }


                                var year = $self.parts_number;
                                year.forEach(element => {

                                    let partsListUl = document.createElement('ul');
                                        let partsN = document.createElement('li');
                                        partsN.setAttribute('class', 'parts-number');
                                        partsN.innerHTML = element;
                                        partsListUl.appendChild(partsN);

                                    carPartsR.appendChild(partsListUl);
                                });

                            }

                        }

                    }
                    
                },
                complete: function (element) {
                    carParts.addEventListener('click', function (e) {
                        var carParts__ = $("#autoparts_parts_number");
                        carPartsR.classList.remove('d-none');
                        carPartsR.classList.add('d-block');
                        
                        $(document).on("mouseup", function (e) {
                            var datafetch = $("#datafetch");
                            if (!datafetch.is(e.target) && datafetch.has(e.target).length === 0) {
                                datafetch.removeClass('d-block');
                                datafetch.addClass('d-none');
                                
                            }
                        });
                        
                        var listclass = jQuery("#datafetch ul li");

                        carParts.addEventListener('keyup', function (e) {
                            var val = $(this).val().toLowerCase();
                            console.log(val);
                            listclass.hide();

                            listclass.each(function () {

                                var text = $(this).text().toLowerCase();

                                if (text.indexOf(val) != -1) {

                                    $(this).show();
                                }
                            });
                        });

                        listclass.each(function () {
                            jQuery(this).on("click", function () {
                                var value = jQuery(this).text();
                                jQuery(this).parents(".input-field").find("input").val(value);

                                carPartsR.classList.remove('d-block');
                                carPartsR.classList.add('d-none');

                            });
                        });
                        
                    })
                    
                    
                    
                },
                error: function (xhr) {
                    console.log('xhr error: ' + xhr.responseText);
                }


            });
        };
    }    
    
    

})(jQuery);
